/* Node version of Monitor Macros */

define(MAXTRACE,1)
define(ENDLAB,5283) dnl
define(MLABEL,4222) dnl
define(NODE_PID,2) dnl
define(HOST_NID,0x8000)

/*  delay(<monitor>,<queue>) */
define(DELAY,
	`$1.count[$2]++;
	 $1.lock = 0;   
	 $1.queue[$2] = 1;   
	')

/*  continue(<monitor>,<queue>) */
define(CONTINUE,
           `if ($1.count[$2] == 0)
            {
                $1.lock = 0;
            }
            else
            {
                ($1.count[$2])--;
                $1.queue[$2] = 0;
            }
            goto `L'ENDLAB;
')

/*  menter(<monitor>) */
define(MENTER,
      `{
           ($1.lock) = 1;
       }') 
	   
/*  mexit(<monitor>) */
define(MEXIT,
		`$1.lock = 0;
		`L'ENDLAB: ;
		define(`ENDLAB',eval(ENDLAB+1))'
      )

/*  decvar(<monitor>,<queues>,<extra_code_for_more_variables>) */
define(DECVAR,
           `struct $1TYP {                                                    
              char  lock;
               ifelse(eval($2 > 0),1,int count[$2];,)
               ifelse(eval($2 > 0),1, char queue[$2];,)
               $3                       
           } $1;'
)

/*  moninit(<monitor>,<queues>) */
define(MONINIT,
`{
	int q_num;
	ifelse(eval($2 > 0),1,
	for (q_num=0; q_num < $2; q_num++)
	{
		$1.count[q_num] = 0;
		$1.queue[q_num] = 0;
		$1.queue[q_num] = 1;
	}
	,,)
		$1.lock = 0;
}
')
    
/* clock(<clock_val>) */
define(CLOCK,
	`{
	 long xtime;
         xtime = *timer; 
	     $1 = xtime;
	 }'
)

define(TRACE_STRUCT,`
struct zz_trace_entry {
	int id;
	int typ;
	int data;
};
struct zz_trace_struct {
	int next_entry;
	struct zz_trace_entry trace_table[MAXTRACE];
};
')

define(BUFF_SIZE,256)

/* env(<max_procs>,<sh_mem>,<sr_buffs>)) */
define(ENV,`

	int xx_i,xx_n;
	char *xx_c1,*xx_c2;
	struct xx_buffer *xx_b1,*xx_b2;
	struct xx_msg *xx_m1,**xx_mp;
	struct xx_process *xx_mque;
	int xx_found,xx_len,xx_rem;

	define(`MAX_PROCS',`ifelse($1,,50,$1)')
	define(`SH_MEM',`ifelse($2,,30000,$2)')
	define(`SR_BUFFS',`ifelse($3,,50,$3)')
	int xxwaiti;
	char *xx_mem();
	int xx_type;
	int xx_my_id;

	char s[256];

	/* begin intel message passing declarations */

	int  copen   ();
	void cclose  ();
	void send    ();
	void sendw   ();
	void recv    ();
	void recvw   ();
	int  status  ();
	int  probe   ();
	void flick   ();
	void handler ();
	int  mynode  ();
	int  cubedim ();
	long clock   ();
	void syslog  ();


	int ipsc_cid,ipsc_type,ipsc_node,ipsc_pid;
	int ipsc_cnt;

	struct ipsc_msg {
		int  type;
		int  pid;
		int  ln;
		int  ack;
		char buf[8192];
		}; 
	struct ipsc_msg *ipsc_buf;
	struct ipsc_msg ipsc_msg;

	struct ipsc_null {
		int  type;
		int  pid;
		int  ln;
		int  ack;
		}; 
	struct ipsc_null null_msg;

	/* end intel message passing declarations */

	struct xx_cluster *xx_cmem;

	struct xx_msg {
		struct xx_msg *link;
		int sender;
		int type;
		int ack;
		struct xx_buffer *first_buff;
	};

	struct xx_buffer {
		struct xx_buffer *link;
		int ln;			/* # characters of buff that are data */
		char buff[BUFF_SIZE];
	};

	typedef int PROC_ID;

	struct xx_process {
		int cpid;  /* take the process id from unix */
		struct xx_msg *first_msg,*last_msg;
	};

	struct xx_cluster {
		struct xx_buffer *avail_buffs;
		struct xx_msg *avail_msgs;
		struct xx_process *active_processes;
	};
	int envi,envj,envk;
	struct xx_buffer *xx_b1;
	struct xx_msg *xx_m1;
	struct xx_process *xx_p1;
')

/* initenv(<global_memory>) */
define(INITENV,`
{
		define(`SH_MEM',`ifelse($2,,30000,$2)')
	
	    xx_mem(0, SH_MEM );
	
	    /* begin cube stuff */

		ipsc_pid = mypid();
	
	    ipsc_cid = copen(ipsc_pid);
	
	    ipsc_buf = &(ipsc_msg);
	
	    /* end cube stuff */
				sprintf(s,"before xx_cmem");
				/* syslog(0,s); */
	    xx_cmem = (struct xx_cluster *) 
			  G_MALLOC(sizeof(struct xx_cluster));
				sprintf(s,"after xx_cmem");
				/* syslog(0,s); */
	
	    /* now allocate and format the buffer pool */
	
	
	    envk = SR_BUFFS ;
	    envi = envk * BUFF_SIZE;
				sprintf(s,"before avail_buffs");
				/* 				syslog(0,s); */
	    xx_cmem->avail_buffs = (struct xx_buffer *) G_MALLOC(envi);
				sprintf(s,"after avail_buffs");
				/* syslog(0,s); */
	    for (envj=0,xx_b1=xx_cmem->avail_buffs; envj < envk; envj++,xx_b1++)
		xx_b1->link = xx_b1+1;
	    xx_b1--;
	    xx_b1->link = 0;
	
	    /* initialize msg avail */
	    envk = SR_BUFFS ;
	    envi = envk * sizeof(struct xx_msg);
				sprintf(s,"before avail_msgs");
				/* syslog(0,s); */
	    xx_cmem->avail_msgs = (struct xx_msg *) G_MALLOC(envi);
	    for (envj=0,xx_m1=xx_cmem->avail_msgs; envj < envk; envj++,xx_m1++)
		xx_m1->link = xx_m1+1;
	    xx_m1--;
	    xx_m1->link = 0;
				sprintf(s,"after avail_msgs");
				/* syslog(0,s); */
	
	    /* initialize active processes */
		xx_cmem->active_processes = 0;
	
	    /* now put node process in */

				sprintf(s,"before active_processes");
			/*	syslog(0,s); */

		xx_cmem->active_processes = xx_p1 =
		    (struct xx_process *) G_MALLOC(sizeof(struct xx_process));

				sprintf(s,"after active_processes");
				/* syslog(0,s); */

		xx_p1->first_msg = xx_p1->last_msg = 0;

		sprintf(s,"xx_p1 = %d",xx_p1);
		syslog(0,s); 
		xx_p1->cpid = mynode();
		sprintf(s,"xx_p1->cpid = %d",xx_p1->cpid);
		syslog(0,s);
	    xx_my_id = mypid();
		sprintf(s,"xx_my_id = %d",xx_my_id);
		syslog(0,s);
	   
	}
	')

/* who_am_i(<proc_id>) */
define(WHO_AM_I,`
	    {
		*($1) = mypid();
	}
	')
	
/* where_am_i(<node>) */
define(WHERE_AM_I,`*($1) = mynode();')

/* char *G_MALLOC(<size>)
*/
define(G_MALLOC, `xx_mem(1,$1); ')
	
define(G_AREA,`xx_mem(2,0);')

define(MEM_BLK,`
	    struct mem_blk {
		char *next;
		int l_mem;
	};
	')
define(LOG_EVENT,`lgevnt(xx_cmem->trace_data,xx_my_id,$1,$2);')
define(DUMP_TRACE,`dtrc(xx_cmem->trace_data);
	')
define(WAIT_FOR_END,`for(xxwaiti=1;xxwaiti<=$1;xxwaiti++) wait(0);')

define(LOAD,`
		    if (*($1) == 0)
		    *($2) = 1000;
		else
		{
			exit(3);
		}
	')
	
/* send_r(<process_id>,<msg_type>,<msg>[,<ln>]) */
define(SENDR,`
	{
	PROC_ID xx_proc;
	int ack_type;
	
	    SEND($1,$2,$3,$4,ack)
	    RECEIVE(&xx_proc,&ack_type,, (match_id($1) && match_type(9999)))
	}
	')

/* send(<process_id>,<msg_type>,<msg>[,<ln>][,<ack_requested>]) */
define(SEND,`
	    {

		strncpy(ipsc_msg.buf,ifelse($3,,null_msg,$3),
		ifelse($4,,sizeof(ifelse($3,,null_msg,$3)),$4));
		ipsc_msg.type = $2;
		ipsc_msg.pid = *($1);
		ipsc_msg.ln = ifelse($4,,sizeof(ifelse($3,,null_msg,$3)),$4);
		ipsc_msg.ack = ifelse($5,,0,1);

		sendw(ipsc_cid,3,ifelse($3,,null_msg,ipsc_buf),
		ifelse($4,,sizeof(ifelse($3,,null_msg,$3))+8,$4+8),*($1),*($1));
	}
	')
	
	
define(match_id,`(xx_m1->sender == *($1))')
define(match_type,`(xx_m1->type == $1)')
		
/* receive(<process_id>,<msg_type>,<msg>,<cond>[,<ln>]) */
define(RECEIVE,`
		    {
				sprintf(s,"starting receiv");
				syslog(0,s);
			xx_mque = xx_cmem->active_processes;
			xx_found = 0;
			xx_mp = &(xx_mque->first_msg);
			while (!xx_found) /* have we found the right message yet ? */
			{
			    while  (*xx_mp)  /* is there a first message ? */
			    { 
				sprintf(s,"inside loop on xx_mp");
				syslog(0,s);
			    	xx_m1 = *xx_mp;
			    	*($1) = ipsc_buf->pid;
			    	*($2) = ipsc_buf->type;
			    	if ($4)
			   			{
				/* now we copy from buffers into msg area */
					ifelse($5,,,*($5)=0;)
						xx_b2=0;
						for (xx_b1=xx_m1->first_buff,xx_c1 = ((char *) ifelse($3,,0,$3)); 
						     (xx_b1);
						     xx_b1=xx_b1->link)
						{
						    for (xx_i=xx_b1->ln, xx_c2=xx_b1->buff;
							 (xx_i);
							 xx_i--)
						    {
								ifelse($3,,,*(xx_c1++) = *(xx_c2++);)
						    }
						    ifelse($5,,,*($5) += xx_b1->ln;)
						    xx_b2 = xx_b1;
						}
						xx_found = 1;
						if (xx_mque->last_msg == *xx_mp) 
							/* are pointing at the last message ?*/
				     		xx_mque->last_msg = ((struct xx_msg *) xx_mp);
						*xx_mp = (*xx_mp)->link;
						if (!(xx_mque->first_msg))
				   				 xx_mque->last_msg = 0;
			    }
			    else {
					xx_mp = &((*xx_mp)->link);
/* 					The condition code failed so lets look at
					the next message in the queue.  */		
				}
		    } 
			sprintf(s,"after loop on xx_mp");
			syslog(0,s);
			if (!xx_found) 
/* 	No messages matching the condition code
	were found so we do a recvw.  */
				{
				sprintf(s,"doing a recvw ");
				syslog(0,s);
					recvw(ipsc_cid,3,ipsc_buf,ifelse($5,,
						ifelse($3,,8,sizeof(*($3))+8),$5+8),
						&ipsc_cnt,&ipsc_node,&ipsc_pid);
					Sprintf(s,"got message from %d ",ipsc_node);
					syslog(0,s);
						xx_len = ipsc_cnt - 8;
					if (xx_len)
/*	The message is non empty
	so we get some buffers.  */
					{
						xx_n = (xx_len + (BUFF_SIZE - 1)) / BUFF_SIZE;
						xx_b1 = xx_cmem->avail_buffs;
						for (xx_b2=xx_b1, xx_i=xx_n; 
							(xx_b2) && (--xx_i); 
							xx_b2=xx_b2->link);
						if (!xx_b2)  exit(3); 
						xx_cmem->avail_buffs = xx_b2->link;
						xx_b2->link = 0;
					}
					else
						xx_b1=0;
					xx_m1 = xx_cmem->avail_msgs;
					xx_cmem->avail_msgs = xx_m1->link;
					xx_m1->first_buff = xx_b1;
					xx_m1->link = 0;
					xx_m1->sender = ipsc_msg.pid;
					xx_m1->type = ipsc_msg.type;
					xx_m1->ack = ipsc_msg.ack;
				sprintf(s,"recv d  ipsc_msg.ack = %d ",ipsc_msg.ack);
				syslog(0,s); 
		
					if (xx_len)
/*	Now we can copy the message into the buffers */
					{
						for (xx_b2=xx_b1,xx_rem=xx_len,xx_c1=((char *) ipsc_msg.buf);
							 xx_rem;
							 xx_b2 = xx_b2->link)
						{
							if (xx_rem > BUFF_SIZE)
								xx_i = BUFF_SIZE;
							else
								xx_i = xx_rem;
							xx_rem = xx_rem - xx_i;
							xx_b2->ln = xx_i;
							for (xx_c2=xx_b2->buff; xx_i--;)
								*(xx_c2++) = *(xx_c1++);
						}
					} /* End of message copy */
/*					Link into the message queue */
					if (xx_mque->first_msg)
					{
							xx_mque->last_msg->link = xx_m1;
							xx_mque->last_msg = xx_m1;
					}
					else
						 xx_mque->first_msg = xx_mque->last_msg = xx_m1;
			 	} /* End of recvw */
			} /* End of big receive loop */

/*	We should have a message that meets the condition code
	now.  We check the ack flag and send an ack if need be.  */
			if (xx_m1->ack)
			{
				sprintf(s,"before ack send ");
				syslog(0,s); 
			    SEND($1,9999)
			}
/*	Take the message header and list of buffs out of the
	avail lists.  */
			xx_m1->link = xx_cmem->avail_msgs;
			xx_cmem->avail_msgs = xx_m1;
			if (xx_b2) {
			    xx_b2->link = xx_cmem->avail_buffs;
			    xx_cmem->avail_buffs = xx_m1->first_buff;
			}
		 }
		')

/* remote_create(<proc_group>,<proc_ids>) */
define(REMOTE_CREATE,`
		    {
			$1();
		}
	')
	
/* process_group(<group_name>,<proc_ids>) */
define(PROCESS_GROUP,`
	      $1()
	 {
	')

/* process_entry(<filename>,<node_number>,<proc_ids>) */
define(PROCESS_ENTRY,`
		    load($1,$2,$3);
	')
	
/* process_group_end */
define(PROCESS_GROUP_END,`
	}
	')

/* copy_id(<to_id>,<from_id>)
define(COPY_ID,` *($1) = *($2);')
		
/* type(<msg_type>,<C_structure>) */
define(MSG_TYPE,`
		    ifelse($2,EMPTY,,`
		   		$2
				define(`I',`eval(index($2,`{')-1)')
				define(`TYPE_LEN_$1',sizeof(substr($2,0,I))) 
			') 
		')
define(BEGIN_MSG_TYPES,)
define(END_MSG_TYPES,)

